{-----------------------------------------------------------------
	this is a component to provide applications with a gradient and
  buttons in the titlebar. i really wrote the code for this
  component on my own, but i took a lot of ideas from other free-
  warecomponents. first i had to learn how to handle the nonclient-
  area of a window and then i had to learn a lot of creating a
  propertyeditor for delphi. i'm not through with learning about
  it, but i think, this component is worth being released.

  if you have trouble with this component or ideas for enhancing it
  then you can contact me via e-mail at

  andreas.perlitz@btg-agb.isar.de
  or
  aperlitz@mail.augustanet.de
  ----------------------------------------------------------------
	before we start i have to thank Brad Stowers for his help in
  making this component work. i wouldn't have been able to create
  it if he hadn't such an impressive deep knowledge of the Windows
  API and the readiness to share this knowledge with me.
  SANX A LOT!
  ----------------------------------------------------------------
  i created this component with Delphi 1.0 under Windows NT. i know,
  i know, many people will think now that i am completely crazy,
  but i want my programs to run also under Windows 3.x (at least
  until Microsoft releases a better followup than Windows 95). but
  this is the reason why i cannot guarantee that it will work in
  every environment.

  so mnuch for pathos. let's go on:

  to install this component simply copy the files CAPBAR.PAS and
  CAPBARED.PAS in the path where Delphi looks for it's components
  (normally this will be C:\DELPHI\LIB). then go to OPTIONS in your
  Delphi-environment and choose INSTALL COMPONENT (or something
  that sounds like this, i only have the german version of Delphi).
  then select the file APCOMPS.PAS to add the component.
  that's all!

	okay, what can this component do? if it is activated (Enabled=True)
  then it paints the titlebar of the form on which it is placed with
  a gradient that is defined by ColorActiveLeft and ColorActiveRight
  (or ColorInActiveLeft and ColorInActiveRight if the form is
  inactive). the fading from color1 to color2 is done in as many
  steps as are given in the property GradientSteps. GradientWaves
  defines the number of fadings that should be done from left to
  right. if GradientSwap is true then the fading is done in real
  waves.
  i think this is a little confusing. so here is a little example:
  Left Color ist Black
  Right Color is Yellow
  GradientWaves is 0

  with these settings you get a fading from black on the left to
  yellow on the right. if you set GradientWaves to 1 and GradientSwap
  to true then you get a fading from black on the left to yellow
  in the middle of the titlebar and back to black on the right.
  if you set GradientSwap to false then you get a fading from black
  on the left to yellow in the middle. then it again starts with
  black in the middle and fades to yellow on the right. did you get
  the picture? if not then just try it.

  another thing what this component does is to give you the ability
  to limit the size of the form to given values. these are MinWidth,
  MaxWidth, MinHeight and MaxHeight. this is enabled by setting
  LockSize to true (by default it is set to false).

  now you also have the ability to define buttons in the titlebar.
  you do this by clicking on the editbutton in the Buttonsproperty.
  a window will open with two lists. the left list contains the
  buttons that are displayed on the left side of the titlebar and
  the right list shows the buttons for the right side of the
  titlebar. you have add- and delete-buttons on top the lists (i think
  the function needs no explanation) and three buttons to change the
  order of the buttons (change from left to right, one row up and
  one row down). at the bottom of the lists is the closebutton for
  this editor.

  you can define how the buttons are displayed (colors, shape, font,
	caption), if they are enabled or disabled (disabled buttons are
  shown but they do not respond to mouseclicks) and if they are
  active or not. if the Active-property of a button is set to false
  then the button will not be shown.

  okay, i think this is enough. the other properties are explained
  in the sourcecode.

  don't try to understand all...
	                  bert the ;-}

unit CapBar;

interface
uses
	WinTypes, WinProcs, SysUtils, Messages, Classes, Graphics,
  Forms, Dialogs, Buttons, Controls;

type
	{ the record for defining the limits in which
  	the gradient is painted }
  TLimit=Record
  	Left,Right: integer;
  end;

  TButAlign=(baLeft,baRight);
  TCapAlign=(caLeft,caCenter,caRight);
  TCapStr=string[20];

	{ the definition for the buttons in the titlebar }
  TTitleButton=class(TComponent)
  public
    FCaption: TCapStr;							{ the string shown on the button }
    FIdx: integer;                  { the index to define the order of the buttons }
   	FAlign: TButAlign;							{ side the button belongs to }
    FAutoSize: boolean;             { resize button when changing caption }
    FActive: boolean;								{ show/hide button }
    FEnabled: boolean;              { button enabled/disabled }
    FWidth: integer;                { width of button }
    FActTCol,FActBCol: TColor;      { colors of active button (text/background) }
    FInActTCol,FInActBCol: TColor;	{ colors of inactive button }
    FFont: TFont;										{ font for caption }
    Down: boolean;                  { pressed or released }
    Rec: TRect;                     { bounding rectangle of button }
    FStyle: TButtonStyle;           { style of button (bsAutoDetect,bsNew,bsWin31)}
    FRound: boolean;								{ shape of button }
    FOnClick: TNotifyEvent;         { event assigned to button }
    { events used for defining the button }
    procedure SetCaption(Value: TCapStr);
    procedure SetFont(Value: TFont);
		constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  	{ the properties shown in the objectinspector }
  published
  	property Active: boolean read FActive write FActive;
    property AutoSize: boolean read FAutoSize write FAutoSize;
    property Font: TFont read FFont write setfont;
  	property Caption: TCapStr read FCaption write setcaption;
  	property Enabled: boolean read FEnabled write FEnabled;
  	property Width: integer read FWidth write FWidth;
    property ColorTextEnabled: TColor read FActtcol write FActtcol;
    property ColorTextDisabled: TColor read FInActtcol write FInActtcol;
    property ColorButtonEnabled: TColor read FActbcol write FActbcol;
    property ColorButtonDisabled: TColor read FInActbcol write FInActbcol;
  	property Alignment: TButAlign read FAlign write FAlign;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property Style: TButtonStyle read FStyle write FStyle;
    property Rounded: boolean read FRound write FRound;
    { i have to define this property because FIdx has to be saved
    	with the sourcecode to provide the right order of the buttons
      in the titlebar. if anyone knows another way to save this
      value with the component without having to let it show in the
      objectinspector then let me know.}
    property Index: integer read FIdx write FIdx;
  end;

  { the titlebar-component itself }
  TTitleBar=class(TComponent)
  public
  	FCapAlign: TCapAlign;						{ alignment of the caption }
  	FButtons: TList;								{ list of buttons }
  	FOwnerForm: TForm;							{ form that contains the component }
    FHOwner : hwnd;									{ handle of form }
    FPrevWndProc : TFarProc;				{ pointer to original messagehandling of form }
    FEnabled: boolean;							{ guess what? }
    { FGradAll defines if the gradient is drawn on the full width of
    	the tilebar or if it is limited to the space between the buttons.
      if you set it to true then the left color starts on the right
      edge of the last button on the left side and the right color
      is reached at the left edge of the first button on the right
      side. confusing? just try it and see what changes. }
    FGradAll: boolean;
    FActCol1,FActCol2: TColor;			{ colors of active form left/right }
    FInActCol1,FInActCol2: TColor;	{ colors for inactive form }
    FInActTCol: TColor;							{ color for inactive captiontext }
    FFont: TFont;										{ font for the caption (also
    																	contains color for active caption)}
    FSteps,FWaves: integer;					{ steps and waves of gradient,
    																	see at beginning of file }
    FSwap: boolean;									{ swap gradientcolors at each wave }
    FLockSize: boolean;							{ limit size of form }
    FMinWid,FMaxWid: integer;				{ limits for formwidth }
    FMinHig,FMaxHig: integer;       { limits for formheight }
    FActivate: TNotifyEvent;				{ event to be executed when component becomes active }
    FDeActivate: TNotifyEvent;      { event to be executed when component becomes inactive }
    FShowBut,FShowCap: boolean;			{ button and caption display }
    { procedures for componenthandling }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
		function GetCaptionRect: TRect;
  	procedure FormResize(Sender: TObject);
    procedure enable;
    procedure disable;
    procedure CreateButtonList;
    procedure SetFont(Value: TFont);
    procedure SetShowBut(Value: boolean);
    procedure SetShowCap(Value: boolean);
		procedure ShowButton(Cvs: TCanvas;Rec: TRect;But: TTitleButton);
	private
    function DrawTitleBar(Active: boolean):TRect;
    function IsActive: boolean;
		function ShowTitleButtons(Cvs: TCanvas;R: TRect): TLimit;
    procedure SetEnabled(Value: boolean);
    procedure SetSteps(Value: integer);
    procedure SetWaves(Value: integer);
    procedure SetSwap(Value: boolean);
    procedure SetActCol1(Value: TColor);
    procedure SetActCol2(Value: TColor);
    procedure SetInActCol1(Value: TColor);
    procedure SetInActCol2(Value: TColor);
    procedure SetInActTCol(Value: TColor);
    procedure SetCapAlign(Value: TCapAlign);
		procedure DrawGradient(Active: boolean;Cvs: TCanvas;Rec: TRect;Lim: TLimit);
		procedure PaintCaption(Active: boolean;Cvs: TCanvas;Rec: TRect);
    { here are the message-handling-routines for the ownerform of
    	the component. all procedures get the parameter TMessage because
      this wyay it is possible to cover all messagehandling in one
      main-procedure (WndProc) }
		procedure WndProc(var Msg: TMessage);
		procedure WMNCPaint(var Msg: TMessage);
    procedure WMNCActivate(var Msg: TMessage);
    procedure WMNCHitTest(var Msg: TMessage);
    procedure WMNCLButtonDown(var Msg: TMessage);
    procedure WMNCLButtonUp(var Msg: TMessage);
    procedure WMNCMouseMove(var Msg: TMessage);
		procedure WMGetMinMaxInfo(var Msg: TMessage);
  published
  	{ the properties shown in the objectinspector }
    property Enabled: boolean read FEnabled write SetEnabled;
    property FullGradient: boolean read FGradAll write FGradAll;
    property ColorActiveLeft: TColor read FActcol1 write SetActCol1;
    property ColorActiveRight: TColor read FActcol2 write SetActCol2;
    property ColorInActiveLeft: TColor read FInActcol1 write SetInActCol1;
    property ColorInActiveRight: TColor read FInActcol2 write SetInActCol2;
    property CaptionInActive: TColor read FInActTCol write SetInActTCol;
    property CaptionAlignment: TCapAlign read FCapAlign write SetCapAlign;
    property GradientSteps: integer read FSteps write SetSteps;
    property GradientWaves: integer read FWaves write SetWaves;
    property GradientSwap: boolean read FSwap write SetSwap;
    property LockSize: boolean read FLockSize write FLockSize;
    property MinWidth: integer read FMinWid write FMinWid;
    property MinHeight: integer read FMinHig write FMinHig;
    property MaxWidth: integer read FMaxWid write FMaxWid;
    property MaxHeight: integer read FMaxHig write FMaxHig;
    property OnEnable: TNotifyEvent read FActivate write FActivate;
    property OnDisable: TNotifyEvent read FDeactivate write FDeactivate;
    property Buttons: TList read FButtons write FButtons;
    property ShowButtons: boolean read FShowBut write SetShowBut;
    property ShowCaption: boolean read FShowCap write SetShowCap;
    property Font: TFont read FFont write SetFont;
  end;

{ this constant is used to identify if a button was hit with the
 	mouse in the nca (nonclientarea) of the form. i added 50 to
  htSizeLast (which is the biggest value for the messagehandling
  on my system) to be sure that there is no greater value used
  by windows.}
const
 	htTitleButton=htSizeLast+50;

implementation

{ constructor for the buttons }
constructor TTitleButton.Create(AOwner: TComponent);
begin
	Inherited Create(AOwner);
  FFont:=TFont.Create;
	FFont.Size:=8;
	FFont.Name:='Arial';
  FFont.Style:=[fsbold];
 	FAlign:=baLeft;
  FAutoSize:=True;
  FCaption:='';
  FActive:=True;
  FEnabled:=True;
  FWidth:=10;
  Down:=False;
  Rec.Left:=0;
  Rec.Top:=0;
  Rec.Right:=10;
  Rec.Bottom:=10;
  FActTCol:=clWindowText;
  FInActTCol:=clGrayText;
  FActBCol:=clBtnFace;
  FInActBCol:=clBtnFace;
  FRound:=False;
  FStyle:=bsNew;
  FOnClick:=nil;
end;
{*****************************************************************
***                                                            ***
***  procedures for the buttons                                ***
***                                                            ***
*****************************************************************}
{ destructor for the buttons }
destructor TTitleButton.Destroy;
begin
	FFont.Free;
  inherited Destroy;
end;

{ define caption and recalculate width if FAutoSize is true }
procedure TTitleButton.SetCaption(Value: TCapStr);
var
	Bmp: TBitmap;
begin
	FCaption:=Value;
  if not FAutoSize then Exit;
	Bmp:=TBitmap.Create;
  Bmp.Canvas.Font:=Font;
  FWidth:=Bmp.Canvas.TextWidth(FCaption)+8;
  Bmp.Free;
end;

{ define font for button }
procedure TTitleButton.SetFont(Value: TFont);
begin
	FFont.Assign(Value);
end;

{*****************************************************************
***                                                            ***
***  procedures for the titlebar                               ***
***                                                            ***
*****************************************************************}
{ constructor for the titlebar }
constructor TTitleBar.Create(AOwner: TComponent);
var
	i: integer;
begin
  Inherited Create(AOwner);
  { first check, if there is already a titlebar-component on the
  	form.}
	for i:=0 to TForm(AOwner).ComponentCount-1 do
 	begin
 		if (TForm(AOwner).Components[i].Classtype=TTitleBar)
    	and (TForm(AOwner).Components[i]<>Self) then
    begin
    { if a component exists then avoid creation of a new one }
			Raise Exception.Create('There already exists a TitleBar-Component on this Form');
    end;
 	end;

  FButtons:=TList.Create;
  FFont:=TFont.Create;
  FOwnerForm:=TForm(AOwner);
  FFont.Assign(FOwnerForm.Font);
  FEnabled:=True;
  FActCol1:=clBlack;
  FActCol2:=clActiveCaption;
  FInActCol1:=clBlack;
  FInActCol2:=clInActiveCaption;
  FInActTCol:=clInActiveCaptionText;
  FCapAlign:=caLeft;
  FSteps:=64;
  FWaves:=0;
  FSwap:=True;
  FLockSize:=False;
  FGradAll:=True;
  FMinWid:=TForm(Owner).Width;
  FMaxWid:=TForm(Owner).Width;
  FMinHig:=TForm(Owner).Height;
  FMaxHig:=TForm(Owner).Height;
  FShowBut:=True;
  TForm(Owner).BorderIcons:=[];
  { capture WndProc from Ownerform }
  FHOwner:=FOwnerForm.Handle;
  FPrevWndProc:=tfarproc(setwindowlong(FHOwner,GWL_WNDPROC,
  	longint(makeobjectinstance(wndproc))));
  { if the capturing fails then there is no need for this component,
  	so avoid it's creation }
  If FPrevWndProc=nil then Raise Exception.Create('Window hook failed - Removing Component');
  { the PostMessage is needed to tell Windows to show the titlebar
  	at startup. maybe it is not needed on all systems (i heard from
    Brad that it works on his system without this line) but it
    doesn't do anything wrong. so keep it and it will run on every
    system (i hope so). }
  PostMessage(FHOwner,WM_NCPAINT,0,0);
end;

{ destructor for the titlebar }
destructor TTitleBar.Destroy;
var
	i: integer;
begin
	i:=0;
  { we have to check if FOwnerForm exists because the Constructort
  	could have been canceled. }
  if FOwnerForm<>nil then
  begin
  	{ then we have to remove all buttons from the form }
	  while i<FOwnerForm.ComponentCount do
  	begin
  		if FOwnerForm.Components[i].ClassType=TTitleButton then
  	  	FOwnerForm.Components[i].Free
	    else
		    inc(i);
	  end;
  end;
	FButtons.Free;
  FFont.Free;
  If(FPrevWndProc<>nil) and FOwnerForm.Handleallocated then
  	FreeObjectInstance(Pointer(SetWindowLong(FHOwner,GWL_WNDPROC,Longint(FPrevWndProc))));
	Inherited Destroy;
end;

{ create list of buttons }
procedure TTitleBar.CreateButtonList;
var
	i,j,k: integer;
begin
  Buttons.Clear;
	for i:=0 to FOwnerForm.ComponentCount-1 do
  begin
  	if FOwnerForm.Components[i].ClassType=TTitleButton then
    begin
	  	Buttons.Add(TTitleButton(FOwnerForm.Components[i]));
      k:=Buttons.Count-1;
      for j:=0 to k do
      begin
      	if TTitleButton(Buttons[k]).FIdx<TTitleButton(Buttons[j]).FIdx then
        	Buttons.Exchange(k,j);
      end;
    end;
	end;
end;

{ set display of buttons }
procedure TTitleBar.SetShowBut(Value: boolean);
begin
	FShowBut:=Value;
  DrawTitleBar(IsActive);
end;

{ set display of caption }
procedure TTitleBar.SetShowCap(Value: boolean);
begin
	FShowCap:=Value;
  DrawTitleBar(IsActive);
end;

{ define alignment of caption }
procedure TTitleBar.SetCapAlign(Value: TCapAlign);
begin
	FCapAlign:=Value;
  DrawTitleBar(IsActive);
end;

{ define font of caption }
procedure TTitleBar.SetFont(Value: TFont);
begin
	FFont.Assign(Value);
  DrawTitleBar(IsActive);
end;

{ set gradientsteps and check if the waves are more than 1/4 of
	the steps. it makes no sense to make more waves than steps and
  it doesn't look good if you define more waves than 1/4 of the
  steps.}
procedure TTitleBar.SetSteps(Value: integer);
begin
	if Value<8 then Value:=8;
  if Value>255 then Value:=255;
  FSteps:=Value;
  if FWaves>FSteps div 4 then FWaves:=FSteps div 4;
 	DrawTitleBar(IsActive);
end;

{ set gradientwaves and avoid setting them higher than 1/4 of
	gradientsteps.}
procedure TTitleBar.SetWaves(Value: integer);
begin
	if Value>FSteps div 4 then Value:=FSteps div 4;
  if Value<0 then Value:=0;
  FWaves:=Value;
 	DrawTitleBar(IsActive);
end;

{ set gradientswapping }
procedure TTitleBar.SetSwap(Value: boolean);
begin
  FSwap:=Value;
 	DrawTitleBar(IsActive);
end;

{ set enabled }
procedure TTitleBar.SetEnabled(Value: boolean);
var
	TM: TMessage;
begin
	FEnabled:=Value;
  { we have to send this message to paint the caption in the
  	right state. the procedure WMNCActivate handles the painting
    depending on the state of FEnabled.}
  TM.Msg:=WM_NCACTIVATE;
  TM.wParam:=Word(FOwnerForm.Active);
	WndProc(TM);
  { now execute the userdefined events (if any) }
  if (FEnabled) and (Assigned(FActivate)) then
  	FActivate(Self)
	else if (not FEnabled) and (Assigned(FDeActivate)) then
  	FDeActivate(Self)
end;

{ define colors }
procedure TTitleBar.SetActCol1(Value: TColor);
begin
	FActCol1:=Value;
 	DrawTitleBar(IsActive);
end;

procedure TTitleBar.SetActCol2(Value: TColor);
begin
	FActCol2:=Value;
 	DrawTitleBar(IsActive);
end;

procedure TTitleBar.SetInActCol1(Value: TColor);
begin
	FInActCol1:=Value;
 	DrawTitleBar(IsActive);
end;

procedure TTitleBar.SetInActCol2(Value: TColor);
begin
	FInActCol2:=Value;
 	DrawTitleBar(IsActive);
end;

procedure TTitleBar.SetInActTCol(Value: TColor);
begin
	FInActTCol:=Value;
 	DrawTitleBar(IsActive);
end;

{ make enable and disable possible by calling the methods. defining
	these procedures gives the programmer the possibility to type
  TitleBar.Enable;

  instead of

  TitleBar.Enabled:=True;

  it has the same effect, but i like the call of the procedure more
  than setting the property. these procedures are not really
  important. }
procedure TTitleBar.Enable;
begin
	Enabled:=True;
end;

procedure TTitleBar.Disable;
begin
	Enabled:=False;
end;

{ check, if form is active }
function TTitleBar.IsActive: boolean;
begin
	Result:=GetActiveWindow=TForm(Owner).Handle;
end;

{ paint the grasdient in the given rectangle }
procedure TTitleBar.DrawGradient(Active: boolean;Cvs: TCanvas;Rec: TRect;Lim: TLimit);
var
	R: TRect;
  R1,G1,B1: byte;
  R2,G2,B2: byte;
  R3,G3,B3: byte;
  RD,GD,BD: real;
  i,j: integer;
  Col1,Col2: longint;
  Wid: real;
  Waves: integer;
  NextSwitch: integer;

	procedure Exchange(var Val1: byte;var Val2: byte);
	var
		Val3: byte;
	begin
		Val3:=Val1;
	  Val1:=Val2;
  	Val2:=Val3;
	end;

begin
	{ don't do anything if the limits are illegal }
  if Lim.Left>=Lim.Right then exit;
  { limit the rectangle to the given limits }
	Rec.Left:=Lim.Left;
  Rec.Right:=Lim.Right;
  { set the right colorvalues in Col1 and Col2 }
	if Active then
  begin
  	Col1:=ColorToRgb(FActcol1);
    Col2:=ColorToRgb(FActcol2);
  end
  else
  begin
  	Col1:=ColorToRgb(FInActcol1);
    Col2:=ColorToRgb(FInActcol2);
  end;

  { this speeds up the painting if the colors are the same }
  if Col1=Col2 then
  begin
  	Cvs.Brush.Color:=Col1;
    Cvs.FillRect(Rec);
    PaintCaption(Active,Cvs,Rec);
    Exit;
  end;

  { for calculating we need a wavevalue that is increased by one }
  Waves:=FWaves+1;
  { get the red, green and blue values of the colors }
  R1:=GetRValue(Col1);
  G1:=GetGValue(Col1);
  B1:=GetBValue(Col1);
  R2:=GetRValue(Col2);
  G2:=GetGValue(Col2);
  B2:=GetBValue(Col2);

  { calculate the amount the values have to be changed for every step }
  RD:=(R2-R1)/FSteps*Waves;
  GD:=(G2-G1)/FSteps*Waves;
  BD:=(B2-B1)/FSteps*Waves;

  { we need to create a temporary rectangle because we need the
  	original rectangle to paint exactly to the right edge of the
    given area.}
  R.Top:=Rec.Top;
  R.Bottom:=Rec.Bottom;
	R.Right:=Rec.Left;
  Wid:=Rec.Right-Rec.Left;
  { NextSwitch tells us when the next wave starts }
  NextSwitch:=FSteps div Waves;
	j:=0;

  { now do the painting for every step }
  for i:=0 to FSteps do
  begin
  	{ i always take some extra-variables for such calculations because
    	the resulting values are more precise as they would be if i
      only raise the original values with the given value }
	  R3:=R1+Trunc(j*RD);
 		G3:=G1+Trunc(j*GD);
  	B3:=B1+Trunc(j*BD);
  	Cvs.Brush.Color:=RGB(R3,G3,B3);
		R.Left:=R.Right;
    { if it is the last step we have to paint to the right edge of
    	the area because we wouldn't reach exactly the edge with
      calculated values.}
   	if i<FSteps then
	    R.Right:=Rec.Left+Trunc(Wid/FSteps*i)
 	  else
   		R.Right:=Rec.Right;
  	Cvs.FillRect(R);
    inc(j);

    { when we reach the next wave some calculations have to be done }
		if i=NextSwitch then
    begin
    	{ first define the next value where a change has to be done }
			NextSwitch:=i+FSteps div Waves;
      j:=0;
      { if gradientswapping is enabled we have to exchange
      	the colors }
      if FSwap then
      begin
	      Exchange(R1,R2);
  	    Exchange(G1,G2);
    	  Exchange(B1,B2);
	      RD:=-RD;
  	    GD:=-GD;
    	  BD:=-BD;
      end;
    end;
 	end;
  { if the background is painted then we have to draw the caption }
  PaintCaption(Active,Cvs,Rec);
end;

{ paint the caption in the given rectangle }
procedure TTitleBar.PaintCaption(Active: boolean;Cvs: TCanvas;Rec: TRect);
var
	DC: HDC;
	Format: Word;
  S: string;
  Ptr: PChar;
begin
	{ if caption should not show up then leave it alone }
	if not FShowCap then Exit;

  { set the font for the canvas }
	Cvs.Font:=FFont;
  { set the appropriate color }
  if not Active then
  	Cvs.Font.Color:=FInActTCol;

	{ define the format of the caption (alignment left, center or right)}
  Format:=Ord(FCapAlign) or DT_VCENTER or DT_SINGLELINE;
  { the background of the caption has to be transparent because we
  	have to save our gradientpainting }
  SetBkMode(Cvs.Handle,TRANSPARENT);
  { now add an indent of 2 pixels to the left and to the right
  	(it looks better this way) }
  InflateRect(Rec,-4,0);
  { convert the string to a pointer (needed by DrawText)}
  S:=FOwnerForm.Caption;
  Ptr:=@S;
  inc(Ptr);
  { paint the caption }
  DrawText(Cvs.Handle,Ptr,Length(S),Rec,Format);
end;

{ get rectangle of captionarea }
function TTitleBar.GetCaptionRect: TRect;
var
	x,y: integer;
begin
	{ if there is no border then we have nothing to do }
  if FOwnerForm.BorderStyle=bsNone then
  	SetRectEmpty(Result)
  else
  begin
  	{ get the windowrectangle of the ownerform }
    GetWindowRect(FOwnerForm.Handle,Result);
    { recalculate the rectangle to offset 0 }
    OffsetRect(Result,-Result.Left,-Result.Top);
    { get the framewidth for the different borderstyles }
    case FOwnerForm.BorderStyle of
    	bsSingle:
      begin
      	x:=GetSystemMetrics(SM_CXBORDER);
        y:=GetSystemMetrics(SM_CYBORDER);
      end;
      bsSizeable:
      begin
      	x:=GetSystemMetrics(SM_CXFRAME);
        y:=GetSystemMetrics(SM_CYFRAME);
      end;
      bsDialog:
      begin
      	x:=GetSystemMetrics(SM_CXDLGFRAME);
        y:=GetSystemMetrics(SM_CYDLGFRAME);
      end;
    end;
    { now we can calculate the rectangle }
   	Result.Left:=Result.Left+x;
   	Result.Right:=Result.Right-x;
    Result.Top:=Result.Top+y;
    y:=y div 2;
		{ if we have a dialogform then we have to do a little recalculation }
    if FOwnerForm.BorderStyle=bsDialog then y:=y-1;
    Result.Bottom:=Result.Top+GetSystemMetrics(SM_CYCAPTION)-y;
  end;
end;

{ paint the titlebar - our main work }
function TTitleBar.DrawTitleBar(Active: boolean): TRect;
var
  x,y: integer;
  i,w,h: integer;
  R: TRect;
  Cvs,Canv: TCanvas;
  FBmp: TBitMap;
  Limit: TLimit;
begin
	{ if the component is in the designingstate or it is disabled
  	then we can lay back and let Windows do our job }
	if (csDesigning in ComponentState) or (not FEnabled) then Exit;
	{ create bitmap to paint all the stuff offscreen }
  FBmp:=TBitmap.Create;
	try
		Cvs:=FOwnerForm.Canvas;
    Cvs.Handle:=GetWindowDC(FOwnerForm.Handle);
  	w:=FOwnerForm.Width-1;
    h:=FOwnerForm.Height-1;
    { get the rectangle we can paint in }
    R:=GetCaptionRect;
    x:=R.Left;
    y:=R.Top;
    Result:=R;

    { bring the offset of the upper left corner to 0 }
    OffsetRect(R,-R.Left,-R.Top);
    { define the dimensions of the bitmap }
    FBmp.Width:=R.Right;
    FBmp.Height:=R.Bottom;
    { now we have a canvas we can paint on }
    Canv:=FBmp.Canvas;
    { if the gradient should fill the whole tiltebar then paint
    	the gradient before the buttons are painted }
    if FGradAll then
    begin
    	Limit.Left:=R.Left;
      Limit.Right:=R.Right;
	    DrawGradient(Active,Canv,R,Limit);
    end;
    Limit:=ShowTitleButtons(Canv,R);
    { if the gradient should only fill the visible area of the
    	titlebar then paint the gradient after the buttons }
    if not FGradAll then
	    DrawGradient(Active,Canv,R,Limit);

		{ paint 3d-frame around the whole caption }
    Canv.Pen.Color:=clBtnShadow;
 	  Canv.MoveTo(0,R.Bottom-1);
    Canv.LineTo(0,0);
    Canv.LineTo(R.Right-1,0);
    Canv.Pen.Color:=clBtnHighLight;
 	  Canv.LineTo(R.Right-1,R.Bottom-1);
    Canv.LineTo(-1,R.Bottom-1);

    { copy the painted caption to the onscreen formcaption }
    Cvs.Draw(x,y,FBmp);
	finally
  	{ free all resources that were needed }
		ReleaseDC(FOwnerForm.Handle,Cvs.Handle);
    FBmp.Free;
		Cvs.Handle:=0;
  end;
end;

{ draws the given button in the given rectangle on the given canvas }
procedure TTitleBar.ShowButton(Cvs: TCanvas;Rec: TRect;But: TTitleButton);
var
	R: TRect;
  x,y: integer;
begin
	Cvs.Font:=But.Font;
	{ here i let windows do the drawing of the button. maybe i
   	replace the procedure with a procedure of my own in later
    releases.}
	R:=DrawButtonFace(Cvs,Rec,1,But.Style,But.Rounded,But.Down,False);
  { resize the drawing rectangle to avoid painting over the
   	already painted frame }
  InflateRect(R,-1,-1);
  { recalculate the positioning values to center the caption
  	on the button }
  x:=R.Left+(R.Right-R.Left) div 2-Cvs.TextWidth(But.Caption) div 2;
	y:=R.Top+(R.Bottom-R.Top) div 2-Cvs.TextHeight(But.Caption) div 2;
  { get the right colors }
  if But.Enabled then
  begin
		Cvs.Font.Color:=But.FActTCol;
		Cvs.Brush.Color:=But.FActBCol;
  end
  else
  begin
	  Cvs.Font.Color:=But.FInActTCol;
		Cvs.Brush.Color:=But.FInActBCol;
  end;
  { paint the caption }
  Cvs.TextRect(R,x,y,But.Caption);
end;

{ show buttons in captionbar }
function TTitleBar.ShowTitleButtons(Cvs: TCanvas;R: TRect): TLimit;
var
	xl,xr,x,x1,y1: integer;
  R1: TRect;
  i: integer;
  But: TTitleButton;
begin
	{ xl and xr are the limits of buttons (xl is the right edge of
  	the last left button and xr the left edge of the first right button)}
	xl:=R.Left;
  xr:=R.Right;
	Result.Left:=xl+1;
 	Result.Right:=xr-1;
  { if buttons should not be displayed then we are done }
	if not FShowBut then Exit;
  { do the painting for all buttons in the list }
	for i:=0 to Buttons.Count-1 do
  begin
	 	But:=TTitleButton(Buttons[i]);
    { only paint the button if it is active }
  	if But.Active then
    begin
      { recalculate the limits depending on the alignment of the button }
	  	case But.FAlign of
  	  	baLeft:
    	  begin
      		x:=xl;
        	xl:=x+But.Width-1;
	      end;
  	    baRight:
    	  begin
      		x:=xr-But.Width;
        	xr:=x+1;
	      end;
  	  end;
      { now we can calculate the rectangle for the button-drawing }
      But.Rec:=Bounds(x,R.Top,But.Width,R.Bottom-R.Top);
			{ paint the button. i placed this in an extra procedure so
      	i can use it for the propertyeditor too }
      ShowButton(Cvs,But.Rec,But);
    end;
  end;
  { now we have the limits we need }
	Result.Left:=xl+1;
 	Result.Right:=xr-1;
end;
{*****************************************************************
***                                                            ***
***  messageprocessing for the ownerform                       ***
***                                                            ***
*****************************************************************}

{ prevent the form from resizing over the given limits if
	FLockSize is enabled }
procedure TTitleBar.WMGetMinMaxInfo(var Msg: TMessage);
begin
	if FLockSize then
  begin
	  PMinMaxInfo(Msg.lParam)^.ptMinTrackSize.X:=FMinWid;
  	PMinMaxInfo(Msg.lParam)^.ptMinTrackSize.Y:=FMinHig;
	  PMinMaxInfo(Msg.lParam)^.ptMaxTrackSize.X:=FMaxWid;
	  PMinMaxInfo(Msg.lParam)^.ptMaxTrackSize.Y:=FMaxHig;
  end;
end;

{ nca needs repainting }
procedure TTitleBar.WMNCActivate(var Msg: TMessage);
begin
	if not FEnabled then
  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 	  	Msg.wParam,Msg.lParam);
	DrawTitleBar(bool(Msg.wParam));
end;

{ form is being resized }
procedure TTitleBar.FormResize(Sender: TObject);
begin
	FOwnerForm.Perform(WM_NCACTIVATE,Word(FOwnerForm.Active),0);
end;

{ check if a mousebutton-click hits one of our buttons }
procedure TTitleBar.WMNCHitTest(var Msg: TMessage);
var
	i: integer;
  But: TTitleButton;
  XPos,YPos: integer;
begin
	{ if the buttons are not displayed we have nothing to do }
	if not FShowBut then Exit;
	XPos:=LoWord(Msg.lParam);
  YPos:=HiWord(Msg.lParam);
	{ check a button is hit }
 	for i:=0 to Buttons.Count-1 do
  begin
  	But:=TTitlebutton(Buttons[i]);
    { check if button is active, enabled and the clickpoint
    	is on the button }
		if (But.Active) and (But.Enabled) and
    	(PtInRect(But.Rec,Point(XPos-TForm(Owner).Left,YPos-TForm(Owner).Top))) then
			Msg.Result:=htTitleButton+Ord(i);
  end;
end;

{ left mousebutton pressed in nca }
procedure TTitleBar.WMNCLButtonDown(var Msg: TMessage);
var
	i: integer;
  But: TTitlebutton;
begin
	{ we get the hitted button in wParam (from WMNCHitTest)
  	first we raise all buttons }
 	for i:=0 to Buttons.Count-1 do
		TTitlebutton(Buttons[i]).Down:=False;
  { then we check if one of our buttons was hit or something else
  	(like a menuentry) }
	if Msg.wParam>=htTitleButton then
  begin
    i:=Msg.wParam-htTitleButton;
  	But:=TTitlebutton(Buttons[i]);
    { if a button was hit and it is enabled and active then it
    	should be displayed as pressed }
    if (But.Active) and (But.Enabled) then
	  	But.Down:=True;
  end;
  { and then we have to show the changes }
  DrawTitleBar(IsActive);
end;

{ left mousebutton released in nca - this tells us that the button
	has pressed and the user wants to execute the defined action }
procedure TTitleBar.WMNCLButtonUp(var Msg: TMessage);
var
	i: integer;
  But: TTitleButton;
begin
	{ only do it if it was one of our buttons }
	if Msg.wParam>=htTitleButton then
  begin
		i:=Msg.wParam-htTitleButton;
 		But:=ttitlebutton(buttons[i]);
		if (Msg.wParam>=htTitleButton) and	(But.Down) then
	  begin
    	{ release the button and show it }
  		But.Down:=False;
 	  	DrawTitleBar(IsActive);
      { if an event is assigned to the button then do it }
	 		if Assigned(But.FOnClick) then But.FOnClick(Self);
  	end;
  end;
  DrawTitleBar(IsActive);
end;

{ mouse moved in nca }
procedure TTitleBar.WMNCMouseMove(var Msg: TMessage);
var
	i: integer;
begin
	{ we have to check if the mouse is moved to release the buttons
  	if the mouse is pressed but moved outside the bounds of the
    pressed button. if we wouldn't do this the button will remain
    pressed. }
  if (Msg.wParam<htTitleButton) or
  	((not TTitleButton(Buttons[Msg.wParam-htTitleButton]).Down) and
    (TTitleButton(Buttons[Msg.wParam-htTitleButton]).Active)) then
  begin
	 	for i:=0 to Buttons.Count-1 do
    	TTitlebutton(Buttons[i]).Down:=False;
  	DrawTitleBar(IsActive);
  end;
end;

{ paint nonclientarea - this is the mainprogram that handles the
	painting of the nca of the form. and it is also the part where
  Brad helped me a lot! }
procedure TTitleBar.WMNCPaint(var Msg: TMessage);
var
  WR,R: TRect;
  DC: HDC;
  MyRgn: HRGN;
  Deletergn: boolean;
  ExRgn: HRGN;
begin
  DeleteRgn:=False;
  { first we need the region we have to paint and a handle of the
  	form we paint on }
  MyRgn:=Msg.wParam;
  DC:=GetWindowDC(FOwnerForm.Handle);
  try
  	{ here we get the entire rectangle of the form }
    GetWindowRect(FOwnerForm.Handle,WR);
    { now we try to get the clippingregion }
    if SelectClipRgn(DC,MyRgn)=Error then
    begin
    	{ if we don't get a region (maybe the Window is shown the
      	first time) we have to create our own region }
      MyRgn:=CreateRectRgn(WR.Left,WR.Top,WR.Right,WR.Bottom);
      SelectClipRgn(DC,MyRgn);
      DeleteRgn:=True;
    end;
    { set the offset of the upper left corner to 0 }
    OffsetRgn(MyRgn,-WR.Left,-WR.Top);
    { now draw our gradientstuff }
    R:=DrawTitleBar(IsActive);
    { now we have to exclude the drawn region from the area that
    	windows draws in. we do this with creating a new region that
      contains the entire drawingregion and excludes our region}
    ExRgn:=CreateRectRgn(R.Left,R.Top,R.Right,R.Bottom);
  	{ CombineRgn with RGN_DIFF creates a region that contains all
    	of the first region (MyRgn) that is not part of the second
      region (ExRgn)}
    CombineRgn(MyRgn,MyRgn,ExRgn,RGN_DIFF);
    { now we can throw away the temporary region }
    DeleteObject(ExRgn);
    { we have to bring the region to the right coordinates again }
    OffsetRgn(MyRgn,WR.Left,WR.Top);
    { now Windows can draw it's stuff (frame, menus and whatever
    	it likes as long as it doesn't touch our caption)}
		Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,MyRgn,Msg.lParam);
  finally
  	{ when we are finished we have to clean up the systemressources }
    if DeleteRgn then DeleteObject(MyRgn);
    ReleaseDC(FOwnerForm.Handle,DC);
  end;
end;

{ messageprocessing for parent formular }
procedure TTitleBar.WndProc(var Msg: TMessage);
begin
	{ only process the messages if the component is enabled and not
  	in designingstate. else let Windows do the job }
	if (csDesigning in ComponentState) or (not FEnabled) then
  begin
  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 	  	Msg.wParam,Msg.lParam);
  	Exit;
  end;

  { and here are the calls to the procedures we have defined }
  case Msg.Msg of
  	WM_NCPAINT:
    begin
    	WMNCPaint(Msg);
    end;
 		WM_NCACTIVATE:
    begin
    	WMNCActivate(Msg);
      Msg.Result:=1;
    end;
    WM_NCLBUTTONDown:
    begin
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    	WMNCLButtonDown(Msg);
    end;
    WM_NCLBUTTONUP:
    begin
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    	WMNCLButtonUp(Msg);
    end;
    WM_NCMOUSEMOVE:
    begin
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    	WMNCMouseMove(Msg);
    end;
    WM_NCHITTEST:
    begin
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    	WMNCHitTest(Msg);
    end;
		WM_GetMINMAXINFO:
    begin
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    	WMGetMinMaxInfo(Msg);
    end;
    WM_SHOWWINDOW:
    begin
    	CreateButtonList;
	  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
 		  	Msg.wParam,Msg.lParam);
    end;
  else
  	{ if a message occurs which we don't handle than Windows
    	has to do it }
  	Msg.Result:=CallWindowProc(FPrevWndProc,FHOwner,Msg.Msg,
      Msg.wParam,Msg.lParam);
  end;
end;

end.
